/*******************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 *******************************************************************************
 
   Filename:
    $Workfile: CanDl_Public.h $
   Last Modification:
    $Author: Alexanderw $
    $Modtime: 19.12.07 11:50 $
    $Revision: 17 $
   
   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes
 
   Description:
     
    Can Dl
    public
   
   Changes:
 
     Version    Date        Author
        Description
     --------------------------------------------------------------------------
        
*******************************************************************************/
#ifndef __CAN_DL_PUBLIC_H
#define __CAN_DL_PUBLIC_H

#include "CanDl_DiagStructDef.h"
            
/******************************************************************************/
/* Can Dl public commads */

#define  CAN_DL_CMD_DATA_IND                  0x00002A00
#define  CAN_DL_CMD_DATA_RES                  0x00002A01
#define  CAN_DL_CMD_DATA_REQ                  0x00002A02
#define  CAN_DL_CMD_DATA_CNF                  0x00002A03
#define  CAN_DL_CMD_DATA_HI_REQ               0x00002A04
#define  CAN_DL_CMD_DATA_HI_CNF               0x00002A05
#define  CAN_DL_CMD_START_REQ                 0x00002A06
#define  CAN_DL_CMD_START_CNF                 0x00002A07
#define  CAN_DL_CMD_STOP_REQ                  0x00002A08
#define  CAN_DL_CMD_STOP_CNF                  0x00002A09
#define  CAN_DL_CMD_AP_REGISTER_REQ           0x00002A0A
#define  CAN_DL_CMD_AP_REGISTER_CNF           0x00002A0B
#define  CAN_DL_CMD_SET_FILTER_REQ            0x00002A0C
#define  CAN_DL_CMD_SET_FILTER_CNF            0x00002A0D
#define  CAN_DL_CMD_SET_PRM_REQ               0x00002A0E
#define  CAN_DL_CMD_SET_PRM_CNF               0x00002A0F
#define  CAN_DL_CMD_EVENT_IND                 0x00002A10
#define  CAN_DL_CMD_EVENT_RES                 0x00002A11
#define  CAN_DL_CMD_ENABLE_RXID_REQ           0x00002A12
#define  CAN_DL_CMD_ENABLE_RXID_CNF           0x00002A13
#define  CAN_DL_CMD_EVENT_ACK_REQ             0x00002A14
#define  CAN_DL_CMD_EVENT_ACK_CNF             0x00002A15
#define  CAN_DL_CMD_DIAG_REQ                  0x00002A16
#define  CAN_DL_CMD_DIAG_CNF                  0x00002A17
#define  CAN_DL_CMD_DIAG_RESET_REQ            0x00002A18
#define  CAN_DL_CMD_DIAG_RESET_CNF            0x00002A19
#define  CAN_DL_CMD_TX_ABORT_REQ              0x00002A1A
#define  CAN_DL_CMD_TX_ABORT_CNF              0x00002A1B
#define  CAN_DL_CMD_INIT_REQ                  0x00002A1C
#define  CAN_DL_CMD_INIT_CNF                  0x00002A1D
#define CAN_DL_CMD_AUTO_BAUD_IND					    0x00002AE8
#define CAN_DL_CMD_AUTO_BAUD_RES				      0x00002AE9
#define CAN_DL_CMD_GET_HANDLE_REQ             0x00002AEA
#define CAN_DL_CMD_GET_HANDLE_CNF             0x00002AEB
#define CAN_DL_CMD_SET_AUTOBAUD_FLAGS_REQ     0x00002AEC
#define CAN_DL_CMD_SET_AUTOBAUD_FLAGS_CNF     0x00002AED
#define CAN_DL_CMD_SET_EVENTS_TO_INDICATE_REQ 0x00002AEE
#define CAN_DL_CMD_SET_EVENTS_TO_INDICATE_CNF 0x00002AEF

           
/******************************************************************************/
/* Can Dl public, constants */

#define CAN_DL_PROCESS_QUEUE_NAME               "CAN_DL_QUE"
#define CAN_DL_MAX_FRAME_PER_PACKET             (16)
#define CAN_DL_MAX_FRAME_PER_IND_PACKET         (8)
#define CAN_DL_MAX_ENABLE_RXID_PER_PACKET       (8)
#define CAN_DL_MAX_BYTE_PER_FRAME               (8)

/* Register REQuest mode */
/* This mode opens extended (29 bit) frames automatically.
 * All extended frames goes with due regard to filter settings to the application */
#define	CAN_DL_REGISTER_MODE_REGISTER						           (0)
/* Extended frames are disabled for your application */
#define CAN_DL_REGISTER_MODE_REGISTER_11BIT_ONLY           (1)
/* Unregister application */
#define CAN_DL_REGISTER_MODE_UNREGISTER 				           (2)

/* Paramter types for set parameter command */
#define CAN_DL_PRM_TYPE_PARMETER_SET            (0)
#define CAN_DL_PRM_TYPE_MODE                    (1)
#define CAN_DL_PRM_TYPE_BAUDRATE                (2)
#define CAN_DL_PRM_TYPE_TXABORT_TIME            (3)
#define CAN_DL_PRM_TYPE_EVENTS_TO_INDICATE      (4)
#define CAN_DL_PRM_TYPE_FILTER                  (5)
#define CAN_DL_PRM_TYPE_CONF_LOCK								(6) /* New */
#define CAN_DL_PRM_TYPE_CONF_UNLOCK							(7) /* New */

/* Init modes init command */
#define CAN_DL_INIT_MODE_RESET                  (0)
#define CAN_DL_INIT_MODE_WARMSTART              (1)


/* Operation mode */
#define   CAN_DL_MODE_RXTX                      (0x00000000)
#define   CAN_DL_MODE_LISTEN_ONLY               (0x00000001)
#define   CAN_DL_MODE_IO_0_MONITORING           (0x00010000)
#define   CAN_DL_MODE_IO_1_MONITORING           (0x00020000)
#define   CAN_DL_MODE_IO_0_INVERTED             (0x00040000)
#define   CAN_DL_MODE_IO_1_INVERTED             (0x00080000)

/* Baudrates */
#define CAN_DL_BAUDRATE_AUTO_DETECT 						(0xAB)
#define CAN_DL_BAUDRATE_1000kB                  (1000000)
#define CAN_DL_BAUDRATE_800kB                   (800000)
#define CAN_DL_BAUDRATE_500kB                   (500000)
#define CAN_DL_BAUDRATE_250kB                   (250000) 
#define CAN_DL_BAUDRATE_125kB                   (125000)
#define CAN_DL_BAUDRATE_100kB                   (100000)
#define CAN_DL_BAUDRATE_50kB                    (50000)
#define CAN_DL_BAUDRATE_20kB                    (20000)
#define CAN_DL_BAUDRATE_12_5kB                  (12500)
#define CAN_DL_BAUDRATE_10kB                    (10000)


/* Value for transmit abort timer infinite */
#define   CAN_DL_TX_ABORT_INFINITE              (0)


/* TX abort modes */
#define CAN_DL_ABORT_ALL_CAN_FRAME              (0)
#define CAN_DL_ABORT_ACTUAL_CAN_FRAME           (1)


/* Filter instances */
#define CAN_DL_FILTER_INSTANCE_11BIT            (0)
#define CAN_DL_FILTER_INSTANCE_29BIT            (1)


/* Bus state RX/TX error limits */
#define CAN_DL_ERR_WARNING_LIMIT                (96)
#define CAN_DL_ERR_PASSIVE_LIMIT                (127)
#define CAN_DL_BUS_OFF_LIMIT                    (255)


/* CAN bus state */
#define CAN_DL_BUSSTATE_ERR_ACTIVE              (0)
#define CAN_DL_BUSSTATE_ERR_WARNING             (1)
#define CAN_DL_BUSSTATE_ERR_PASSIVE             (2)
#define CAN_DL_BUSSTATE_BUS_OFF                 (3)


/* Masks CMD event indication */
#define MSK_CAN_DL_BUS_STATE                     0x00000003U 
#define MSK_CAN_DL_EVENT_BUS_STATE_CHANGE        0x00000004U
#define MSK_CAN_DL_EVENT_RX_OVERRUN              0x00000008U
#define MSK_CAN_DL_EVENT_TX_OVERRUN              0x00000010U
#define MSK_CAN_DL_IO_INPUT_STATE                0x00030000U
#define MSK_CAN_DL_IO_0_INPUT_STATE              0x00010000U
#define MSK_CAN_DL_IO_1_INPUT_STATE              0x00020000U
#define MSK_CAN_DL_EVENT_IO_CHANGED              0x00040000U

        
/* Masks CMD enable identifier request */
#define MSK_CAN_DL_CTRL_RXID_ENABLE              0x00000001U 
#define MSK_CAN_DL_CTRL_RXID_RANGE_START         0x00000002U
#define MSK_CAN_DL_CTRL_RXID_RET_USR_UUID        0x00000004U


/* Masks CMD data request */
#define MSK_CAN_DL_CAN_FRAME_INFO_DLC            0x0000000fU /* Data length code            */          
#define MSK_CAN_DL_CAN_FRAME_INFO_RTR            0x00000010U /* Remote transmission request */          
#define MSK_CAN_DL_CAN_FRAME_INFO_CNF_REQUESTED  0x00000020U /* Confirmation request        */          
#define MSK_CAN_DL_CAN_FRAME_INFO_SINGLE_SHOT    0x00000040U /* Send frame as singe shot    */         
#define MSK_CAN_DL_CAN_FRAME_INFO_RES1           0x7fffff80U /* Reserved bits               */         
#define MSK_CAN_DL_CAN_FRAME_INFO_FRAME_FORMAT   0x80000000U /* 29 Bit frame format         */ 


/* Masks for CAN_DL_PARAMETER_T -> ulAutoBaudFlags */
#define MSK_CAN_DL_BAUDRATE_1000kB           0x00000001U
#define MSK_CAN_DL_BAUDRATE_800kB            0x00000002U
#define MSK_CAN_DL_BAUDRATE_500kB            0x00000004U
#define MSK_CAN_DL_BAUDRATE_250kB            0x00000008U
#define MSK_CAN_DL_BAUDRATE_125kB            0x00000010U
#define MSK_CAN_DL_BAUDRATE_100kB            0x00000020U
#define MSK_CAN_DL_BAUDRATE_50kB             0x00000040U
#define MSK_CAN_DL_BAUDRATE_20kB             0x00000080U
#define MSK_CAN_DL_BAUDRATE_12_5kB           0x00000100U
#define MSK_CAN_DL_BAUDRATE_10kB             0x00000200U


/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(CAN_DL_PUBLIC)
#endif


/******************************************************************************/
/* Can Dl public, types and structs */

/* CAN transmit frame */
typedef __PACKED_PRE struct CAN_DL_CAN_TX_FRAME_Ttag {
  TLR_UINT32  ulUniqueId;
  TLR_UINT32  ulFrameInfo;
	TLR_UINT32  ulIdentifier;
	TLR_UINT8   abData[CAN_DL_MAX_BYTE_PER_FRAME];
} __PACKED_POST CAN_DL_CAN_TX_FRAME_T;

/* CAN receive frame */
typedef __PACKED_PRE struct CAN_DL_CAN_RX_FRAME_Ttag {
  TLR_UINT32  ulUniqueId;
  TLR_UINT32  ulFrameInfo;
	TLR_UINT32  ulIdentifier;
	TLR_UINT8   abData[CAN_DL_MAX_BYTE_PER_FRAME];
} __PACKED_POST CAN_DL_CAN_RX_FRAME_T;

/* Enable CAN identifier */
typedef __PACKED_PRE struct CAN_DL_ENABLE_RXID_Ttag {
  TLR_UINT32  ulControlBits;
  TLR_UINT32  ulIdentifier;
  TLR_UINT32  ulUniqueId;  
} __PACKED_POST CAN_DL_ENABLE_RXID_T;

/* Set filter */
typedef __PACKED_PRE struct CAN_DL_ACCEPTANCE_FILTER_Ttag {
  TLR_UINT32  ulInstance;
  TLR_UINT32  ulCode;
  TLR_UINT32  ulMask;    
} __PACKED_POST CAN_DL_ACCEPTANCE_FILTER_T;

/* Set parameter */
typedef __PACKED_PRE struct CAN_DL_PARAMETER_SET_Ttag {
  TLR_UINT32                  ulMode;
  TLR_UINT32                  ulBaudrate;
  TLR_UINT32                  ulTxAbortTime;
  TLR_UINT32                  ulEventsIndicated;
  CAN_DL_ACCEPTANCE_FILTER_T  atFilter[2];
  TLR_UINT32                  ulNumRxIdEnable;
  TLR_UINT32                  ulFirstRxId;
} __PACKED_POST CAN_DL_PARAMETER_SET_T;

typedef __PACKED_PRE  union CAN_DL_PARAMETER_Ttag {
  CAN_DL_PARAMETER_SET_T      tSet;
  TLR_UINT32                  ulMode;
  TLR_UINT32                  ulBaudrate;
  TLR_UINT32                  ulTxAbortTime;
  TLR_UINT32                  ulEventsIndicated;
  CAN_DL_ACCEPTANCE_FILTER_T  tFilter;
} __PACKED_POST CAN_DL_PARAMETER_T;

/* Init request */
typedef __PACKED_PRE  union CAN_DL_INIT_PARAMETER_Ttag {
  CAN_DL_PARAMETER_SET_T      tSet;  
} __PACKED_POST CAN_DL_INIT_PARAMETER_T;

/* Task diagnostic */
#define CAN_DL_DIAG_TYPE_CMD1         (0)
#define CAN_DL_DIAG_TYPE_CMD2         (1)
#define CAN_DL_DIAG_TYPE_STATUS       (2)

typedef __PACKED_PRE  struct CAN_DL_DIAG_CMD2_Ttag {
  /* Command statistic */
  
  TLR_UINT32                ulCyclicEvent;
  TLR_UINT32                ulDrvCanRxInd;  
  TLR_UINT32                ulDrvCanEveInd;
  
  TLR_UINT32                ulCmdDiagReq;
  TLR_UINT32                ulCmdDiagCnfPos;
  TLR_UINT32                ulCmdDiagCnfNeg;
  
} __PACKED_POST CAN_DL_DIAG_CMD2_T;

typedef __PACKED_PRE struct CAN_DL_DIAG_STATUS_Ttag{
/* CAN Status List */

  TLR_UINT32 ulStatus;
  TLR_UINT32 ulTxFrameSucceed;
  TLR_UINT32 ulTxErrorSummary;
  TLR_UINT32 ulRxFrameSucceed;
  TLR_UINT32 ulRxErrorSummary;
  TLR_UINT32 ulTxErrCnt;
  TLR_UINT32 ulRxErrCnt;
  TLR_UINT32 ulArbitrationLost;
  TLR_UINT32 ulIndDroppedDueFifoFull;
  TLR_UINT32 ulConDroppedDueFifoFull;
  TLR_UINT32 ulRxStdFramesFilterd;
  TLR_UINT32 ulRxExtFramesFilterd;
  TLR_UINT32 ulRxStdFramesPassed;
  TLR_UINT32 ulRxExtFramesPassed;     

} __PACKED_POST CAN_DL_DIAG_STATUS_T;


typedef __PACKED_PRE  union CAN_DL_DIAG_Ttag {
  CAN_DL_DIAG_CMD1              tCmd1;
  CAN_DL_DIAG_CMD2_T            tCmd2;
  CAN_DL_DIAG_STATUS_T          tStatus;
} __PACKED_POST CAN_DL_DIAG_T;


/******************************************************************************/
/* Definition of packet data units (=service data units; SDU) */

typedef __PACKED_PRE struct CAN_DL_SDU_DATA_IND_Ttag {
  CAN_DL_CAN_RX_FRAME_T atRxFrame[CAN_DL_MAX_FRAME_PER_IND_PACKET];
} __PACKED_POST CAN_DL_SDU_DATA_IND_T;

typedef __PACKED_PRE struct CAN_DL_SDU_DATA_REQ_Ttag {
  CAN_DL_CAN_TX_FRAME_T atTxFrame[CAN_DL_MAX_FRAME_PER_PACKET]; 
} __PACKED_POST CAN_DL_SDU_DATA_REQ_T;

typedef __PACKED_PRE struct CAN_DL_SDU_DATA_CNF_Ttag {
  CAN_DL_CAN_TX_FRAME_T atTxFrame[CAN_DL_MAX_FRAME_PER_PACKET]; 
} __PACKED_POST CAN_DL_SDU_DATA_CNF_T;

typedef __PACKED_PRE struct CAN_DL_SDU_ENABLE_RXID_REQ_Ttag {
  CAN_DL_ENABLE_RXID_T    atId[CAN_DL_MAX_ENABLE_RXID_PER_PACKET];
} __PACKED_POST CAN_DL_SDU_ENABLE_RXID_REQ_T;

typedef __PACKED_PRE struct CAN_DL_SDU_SET_FILTER_REQ_Ttag {
  CAN_DL_ACCEPTANCE_FILTER_T  tAcceptanceFilter;
} __PACKED_POST CAN_DL_SDU_SET_FILTER_REQ_T;

typedef __PACKED_PRE struct CAN_DL_SDU_SET_PRM_REQ_Ttag {
  TLR_UINT32              ulPrmType;
  CAN_DL_PARAMETER_T      unPrm;
} __PACKED_POST CAN_DL_SDU_SET_PRM_REQ_T;

typedef CAN_DL_SDU_SET_PRM_REQ_T  CAN_DL_SDU_SET_PRM_CNF_T;

typedef __PACKED_PRE struct CAN_DL_SDU_EVENT_IND_Ttag {
  TLR_UINT32              ulEvents;
} __PACKED_POST CAN_DL_SDU_EVENT_IND_T;

typedef __PACKED_PRE struct CAN_DL_SDU_EVENT_RES_Ttag {
  TLR_UINT32              ulEvents;
} __PACKED_POST CAN_DL_SDU_EVENT_RES_T;

typedef __PACKED_PRE struct CAN_DL_SDU_EVENT_ACK_REQ_Ttag {
  TLR_UINT32              ulEvents;
} __PACKED_POST CAN_DL_SDU_EVENT_ACK_REQ_T;

typedef __PACKED_PRE struct CAN_DL_SDU_EVENT_ACK_CNF_Ttag {
  TLR_UINT32              ulEvents;
} __PACKED_POST CAN_DL_SDU_EVENT_ACK_CNF_T;

typedef __PACKED_PRE struct CAN_DL_SDU_AP_REGISTER_REQ_Ttag {
  TLR_UINT32              ulInitMode;
} __PACKED_POST CAN_DL_SDU_AP_REGISTER_REQ_T;

typedef __PACKED_PRE struct CAN_DL_SDU_AP_REGISTER_CNF_Ttag {
  TLR_UINT32              ulInitMode;
} __PACKED_POST CAN_DL_SDU_AP_REGISTER_CNF_T;

typedef __PACKED_PRE struct CAN_DL_TX_ABORT_REQ_Ttag {
  TLR_UINT32              ulMode;
} __PACKED_POST CAN_DL_SDU_TX_ABORT_REQ_T;

typedef __PACKED_PRE struct CAN_DL_SDU_DIAG_REQ_Ttag {
  TLR_UINT32              ulDiagType;
} __PACKED_POST CAN_DL_SDU_DIAG_REQ_T;

typedef __PACKED_PRE struct CAN_DL_SDU_DIAG_CNF_Ttag {
  TLR_UINT32              ulDiagType;
  CAN_DL_DIAG_T           unDiag;
} __PACKED_POST CAN_DL_SDU_DIAG_CNF_T;

typedef __PACKED_PRE struct CAN_DL_SDU_DIAG_RESET_REQ_Ttag {
  TLR_UINT32              ulDiagType;
} __PACKED_POST CAN_DL_SDU_DIAG_RESET_REQ_T;

typedef __PACKED_PRE struct CAN_DL_SDU_INIT_REQ_Ttag {
  TLR_UINT32              ulInitMode;
  CAN_DL_INIT_PARAMETER_T unInitPrm;    
} __PACKED_POST CAN_DL_SDU_INIT_REQ_T;

typedef __PACKED_PRE struct CAN_DL_SDU_INIT_CNF_Ttag {
  TLR_UINT32              ulInitMode;
} __PACKED_POST CAN_DL_SDU_INIT_CNF_T;

typedef __PACKED_PRE struct CAN_DL_SDU_AUTO_BAUD_IND_Ttag {
  TLR_UINT32              ulBaudRate;
} __PACKED_POST CAN_DL_SDU_AUTO_BAUD_IND_T;

typedef __PACKED_PRE struct CAN_DL_SDU_AUTO_BAUD_RES_Ttag {
  TLR_UINT32              ulBaudRate;
} __PACKED_POST CAN_DL_SDU_AUTO_BAUD_RES_T;

typedef __PACKED_PRE struct CAN_DL_SDU_GET_HANDLE_CNF_Ttag {
  TLR_HANDLE              hRscHandle;
  TLR_HANDLE              hIdentHandle;
} __PACKED_POST CAN_DL_SDU_GET_HANDLE_CNF_T;

/* Set auto baud flags request */
typedef __PACKED_PRE  struct CAN_DL_SDU_SET_AUTOBAUD_FLAGS_REQ_Ttag {
  TLR_UINT32      ulAutoBaudFlags;
} __PACKED_POST CAN_DL_SDU_SET_AUTOBAUD_FLAGS_REQ_T;

/* Separate command to register certain events */
typedef __PACKED_PRE  struct CAN_DL_SDU_SET_EVENTS_TO_INDICATE_REQ_Ttag {
  TLR_UINT32      ulEventsIndicated;
} __PACKED_POST CAN_DL_SDU_SET_EVENTS_TO_INDICATE_REQ_T;

/******************************************************************************/
/* Definition of packet */

/* Init request/confirmation */
typedef __PACKED_PRE struct CAN_DL_PACKET_AP_REGISTER_REQ_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_AP_REGISTER_REQ_T  tData;        /* Packet data      */
} CAN_DL_PACKET_AP_REGISTER_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_AP_REGISTER_CNF_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_AP_REGISTER_CNF_T  tData;        /* Packet data      */
} CAN_DL_PACKET_AP_REGISTER_CNF_T;



/* Data indication/response */
typedef struct  CAN_DL_PACKET_DATA_IND_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_DATA_IND_T         tData;        /* Packet Data Unit */
} CAN_DL_PACKET_DATA_IND_T;

typedef struct  CAN_DL_PACKET_DATA_RES_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
} CAN_DL_PACKET_DATA_RES_T;



/* Data request/confirmation */
typedef __PACKED_PRE struct CAN_DL_PACKET_DATA_REQ_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_DATA_REQ_T         tData;        /* Packet Data Unit */
} CAN_DL_PACKET_DATA_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_DATA_CNF_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_DATA_CNF_T         tData;        /* Packet Data Unit */
} CAN_DL_PACKET_DATA_CNF_T;

/* Data high priority request/confirmation */
typedef CAN_DL_PACKET_DATA_REQ_T   CAN_DL_PACKET_DATA_HI_REQ_T;   
typedef CAN_DL_PACKET_DATA_CNF_T   CAN_DL_PACKET_DATA_HI_CNF_T;   



/* Set filter request/confirmation */
typedef __PACKED_PRE struct CAN_DL_PACKET_SET_FILTER_REQ_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_SET_FILTER_REQ_T   tData;        /* Packet Data Unit */
} CAN_DL_PACKET_SET_FILTER_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_SET_FILTER_CNF_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
} CAN_DL_PACKET_SET_FILTER_CNF_T;



/* Enable identifier request/confirmation */
typedef __PACKED_PRE struct CAN_DL_PACKET_ENABLE_RXID_REQ_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_ENABLE_RXID_REQ_T  tData;        /* Packet Data Unit */
} CAN_DL_PACKET_ENABLE_RXID_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_ENABLE_RXID_CNF_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
} CAN_DL_PACKET_ENABLE_RXID_CNF_T;



/* Set parameter request/confirmation */
typedef __PACKED_PRE struct CAN_DL_PACKET_SET_PRM_REQ_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_SET_PRM_REQ_T      tData;        /* Packet Data Unit */
} CAN_DL_PACKET_SET_PRM_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_SET_PRM_CNF_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_SET_PRM_CNF_T      tData;        /* Packet Data Unit */
} CAN_DL_PACKET_SET_PRM_CNF_T;



/* Start request/ronfirmation */
typedef __PACKED_PRE struct CAN_DL_PACKET_START_REQ_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
} CAN_DL_PACKET_START_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_START_CNF_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
} CAN_DL_PACKET_START_CNF_T;



/* Stop request/ronfirmation */
typedef __PACKED_PRE struct CAN_DL_PACKET_STOP_REQ_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
} CAN_DL_PACKET_STOP_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_STOP_CNF_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
} CAN_DL_PACKET_STOP_CNF_T;



/* Init request/ronfirmation */
typedef __PACKED_PRE struct CAN_DL_PACKET_INIT_REQ_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_INIT_REQ_T         tData;        /* Packet Data      */
} CAN_DL_PACKET_INIT_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_INIT_CNF_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_INIT_CNF_T         tData;        /* Packet Data      */
} CAN_DL_PACKET_INIT_CNF_T;



/* Event indication/response */
typedef __PACKED_PRE struct CAN_DL_PACKET_CAN_EVENT_IND_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_EVENT_IND_T        tData;        /* Packet Data      */
} CAN_DL_PACKET_EVENT_IND_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_EVENT_RES_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_EVENT_RES_T        tData;        /* Packet Data      */
} CAN_DL_PACKET_EVENT_RES_T;



/* Event Acknowledge  request/confirmation */
typedef __PACKED_PRE struct CAN_DL_PACKET_CAN_EVENT_ACK_REQ_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_EVENT_ACK_REQ_T    tData;        /* Packet Data      */
} CAN_DL_PACKET_EVENT_ACK_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_EVENT_ACK_CNF_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_EVENT_ACK_CNF_T    tData;        /* Packet Data      */
} CAN_DL_PACKET_EVENT_ACK_CNF_T;



/* Tx Abort  request/confirmation */
typedef __PACKED_PRE struct CAN_DL_PACKET_TX_ABORT_REQ_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_TX_ABORT_REQ_T     tData;        /* Packet Data      */
} CAN_DL_PACKET_TX_ABORT_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_TX_ABORT_CNF_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
} CAN_DL_PACKET_TX_ABORT_CNF_T;



/* Diag request/confirmation */
typedef __PACKED_PRE struct CAN_DL_PACKET_CAN_DIAG_REQ_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_DIAG_REQ_T         tData;        /* Packet Data      */
} CAN_DL_PACKET_DIAG_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_DIAG_CNF_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_DIAG_CNF_T         tData;        /* Packet Data      */
} CAN_DL_PACKET_DIAG_CNF_T;



/* Diag reset request/confirmation */
typedef __PACKED_PRE struct CAN_DL_PACKET_CAN_DIAG_RESET_REQ_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_DIAG_RESET_REQ_T   tData;        /* Packet Data      */
} CAN_DL_PACKET_DIAG_RESET_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_DIAG_RESET_CNF_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
} CAN_DL_PACKET_DIAG_RESET_CNF_T;

/* Packet to indicate that auto baud detection was complete */
typedef __PACKED_PRE struct CAN_DL_PACKET_AUTO_BAUD_IND_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_AUTO_BAUD_IND_T    tData;        /* Packet Data Unit */
} CAN_DL_PACKET_AUTO_BAUD_IND_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_AUTO_BAUD_RES_Ttag {
  TLR_PACKET_HEADER_T           tHead;        /* Packet Header    */
  CAN_DL_SDU_AUTO_BAUD_RES_T    tData;        /* Packet Data Unit */
} CAN_DL_PACKET_AUTO_BAUD_RES_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_GET_HANDLE_REQ_Ttag {
  TLR_PACKET_HEADER_T            tHead;        /* Packet Header    */
} CAN_DL_PACKET_GET_HANDLE_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_GET_HANDLE_CNF_Ttag {
  TLR_PACKET_HEADER_T            tHead;        /* Packet Header    */
  CAN_DL_SDU_GET_HANDLE_CNF_T    tData;        /* Packet Data Unit */
} CAN_DL_PACKET_GET_HANDLE_CNF_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_SET_AUTOBAUD_FLAGS_REQ_Ttag {
  TLR_PACKET_HEADER_T                         tHead;        /* Packet Header    */
  CAN_DL_SDU_SET_AUTOBAUD_FLAGS_REQ_T         tData;        /* Packet Data Unit */
} CAN_DL_PACKET_SET_AUTOBAUD_FLAGS_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_SET_AUTOBAUD_FLAGS_CNF_Ttag {
  TLR_PACKET_HEADER_T                         tHead;        /* Packet Header    */
} CAN_DL_PACKET_SET_AUTOBAUD_FLAGS_CNF_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_SET_EVENTS_TO_INDICATE_REQ_Ttag {
  TLR_PACKET_HEADER_T                         tHead;        /* Packet Header    */
  CAN_DL_SDU_SET_EVENTS_TO_INDICATE_REQ_T     tData;        /* Packet Data Unit */
} CAN_DL_PACKET_SET_EVENTS_TO_INDICATE_REQ_T;

typedef __PACKED_PRE struct CAN_DL_PACKET_SET_EVENTS_TO_INDICATE_CNF_Ttag {
  TLR_PACKET_HEADER_T                          tHead;        /* Packet Header    */
} CAN_DL_PACKET_SET_EVENTS_TO_INDICATE_CNF_T;

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(CAN_DL_PUBLIC)
#endif

/***************************************************************************************/
#endif /* #ifndef __CAN_DL_PUBLIC_H */
